import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { useActions } from "../../context/actions.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import {
  useAllowGroup,
  useAllowUngroup,
  useHasLinkShapeSelected,
  useIsInSelectState,
  useThreeStackableItems,
  useUnlockedSelectedShapesCount
} from "../../hooks/menu-hooks.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
function DefaultActionsMenuContent() {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(AlignMenuItems, {}),
    /* @__PURE__ */ jsx(DistributeMenuItems, {}),
    /* @__PURE__ */ jsx(StackMenuItems, {}),
    /* @__PURE__ */ jsx(ReorderMenuItems, {}),
    /* @__PURE__ */ jsx(ZoomOrRotateMenuItem, {}),
    /* @__PURE__ */ jsx(RotateCWMenuItem, {}),
    /* @__PURE__ */ jsx(EditLinkMenuItem, {}),
    /* @__PURE__ */ jsx(GroupOrUngroupMenuItem, {})
  ] });
}
function AlignMenuItems() {
  const actions = useActions();
  const twoSelected = useUnlockedSelectedShapesCount(2);
  const isInSelectState = useIsInSelectState();
  const enabled = twoSelected && isInSelectState;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-left"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-center-horizontal"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-right"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["stretch-horizontal"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-top"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-center-vertical"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["align-bottom"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["stretch-vertical"], disabled: !enabled })
  ] });
}
function DistributeMenuItems() {
  const actions = useActions();
  const threeSelected = useUnlockedSelectedShapesCount(3);
  const isInSelectState = useIsInSelectState();
  const enabled = threeSelected && isInSelectState;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["distribute-horizontal"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["distribute-vertical"], disabled: !enabled })
  ] });
}
function StackMenuItems() {
  const actions = useActions();
  const threeStackableItems = useThreeStackableItems();
  const isInSelectState = useIsInSelectState();
  const enabled = threeStackableItems && isInSelectState;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["stack-horizontal"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["stack-vertical"], disabled: !enabled })
  ] });
}
function ReorderMenuItems() {
  const actions = useActions();
  const oneSelected = useUnlockedSelectedShapesCount(1);
  const isInSelectState = useIsInSelectState();
  const enabled = oneSelected && isInSelectState;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["send-to-back"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["send-backward"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["bring-forward"], disabled: !enabled }),
    /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["bring-to-front"], disabled: !enabled })
  ] });
}
function ZoomOrRotateMenuItem() {
  const breakpoint = useBreakpoint();
  return breakpoint < PORTRAIT_BREAKPOINT.TABLET_SM ? /* @__PURE__ */ jsx(ZoomTo100MenuItem, {}) : /* @__PURE__ */ jsx(RotateCCWMenuItem, {});
}
function ZoomTo100MenuItem() {
  const actions = useActions();
  const editor = useEditor();
  const isZoomedTo100 = useValue("zoom is 1", () => editor.getZoomLevel() === 1, [editor]);
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["zoom-to-100"], disabled: isZoomedTo100 });
}
function RotateCCWMenuItem() {
  const actions = useActions();
  const oneSelected = useUnlockedSelectedShapesCount(1);
  const isInSelectState = useIsInSelectState();
  const enabled = oneSelected && isInSelectState;
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["rotate-ccw"], disabled: !enabled });
}
function RotateCWMenuItem() {
  const actions = useActions();
  const oneSelected = useUnlockedSelectedShapesCount(1);
  const isInSelectState = useIsInSelectState();
  const enabled = oneSelected && isInSelectState;
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["rotate-cw"], disabled: !enabled });
}
function EditLinkMenuItem() {
  const actions = useActions();
  const showEditLink = useHasLinkShapeSelected();
  const isInSelectState = useIsInSelectState();
  const enabled = showEditLink && isInSelectState;
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["edit-link"], disabled: !enabled });
}
function GroupOrUngroupMenuItem() {
  const allowGroup = useAllowGroup();
  const allowUngroup = useAllowUngroup();
  return allowGroup ? /* @__PURE__ */ jsx(GroupMenuItem, {}) : allowUngroup ? /* @__PURE__ */ jsx(UngroupMenuItem, {}) : /* @__PURE__ */ jsx(GroupMenuItem, {});
}
function GroupMenuItem() {
  const actions = useActions();
  const twoSelected = useUnlockedSelectedShapesCount(2);
  const isInSelectState = useIsInSelectState();
  const enabled = twoSelected && isInSelectState;
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["group"], disabled: !enabled });
}
function UngroupMenuItem() {
  const actions = useActions();
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["ungroup"] });
}
export {
  AlignMenuItems,
  DefaultActionsMenuContent,
  DistributeMenuItems,
  EditLinkMenuItem,
  GroupMenuItem,
  GroupOrUngroupMenuItem,
  ReorderMenuItems,
  RotateCCWMenuItem,
  RotateCWMenuItem,
  StackMenuItems,
  UngroupMenuItem,
  ZoomOrRotateMenuItem,
  ZoomTo100MenuItem
};
//# sourceMappingURL=DefaultActionsMenuContent.mjs.map
